#!/usr/bin/perl
# gettabledata.pl
# 時刻表ファイルを読んで表示する値を見つける。
# May , 2005
# yutakano@tim.hi-ho.ne.jp
#
# ファイルの位置は widget/tables/
#	**** 仕様 ****
# 	//  gettabledata.pl    ./tables/CHOFUu1.txt     1    13    45 
#	//  gettabledata.pl 時刻表ファイル名  曜日  時  分
#	// 返り値は「列車種別,時,分,行き先」* 3 の12個をカンマでつないだもの
#	// ex : 特急,13,50,新宿,普通,13,56,桜上水,急行,14,00,新宿
$DEBUG = 0 ; # 0 = Normal : 1 = Debug Mode

# 処理中フラグ。土日処理の判断に使う(汚いなぁ)
# ファイルフォーマットの自由度を増すため。
# ファイルが必ず[SAT]、[SUN]、[HOL]の順番で書いてあればいらないんだけどね。
$inPROCESS = 0 ; # 

$myfilename = @ARGV[0] ;	# 時刻表ファイル名    
$myday = @ARGV[1] ;	# 曜日
$myhour = @ARGV[2] ;	#  時 
$myminute = @ARGV[3] ;	#  分 

$SHARP = "\#";
$DOLLER = chr(36) ; # $ 

$UNKNOWN = "\ " ;	# 列車の種別不明は空欄にしておく
$NOWHERE = "\?";	# 行き先不明は?にする。不親切か？

# 2:59までは前日とする。2時 -> 26時 
if ($myhour < 3){$myhour += 24;};

# 検索(比較)用の時刻を作る 時間*60 + 分
$myhhmm = $myhour * 60 + $myminute  ;
#print "$myhhmm \n" ;
# ファイルの読み込み
open(IN,"$myfilename") or die("open error .$myfilename") ;
@input=<IN> ;
close(IN);

foreach $inputline(@input){
	# データはこんな感じ
	#  5: Zg6 Zg21 Zf27 Zg34 Zf41 Ze47 Zg54
	$tabledata = $inputline ;
	# とりあえずchompで改行削除
	chomp($tabledata) ;
	#print "$tabledata \n" ;
	# まず最初の一文字を判定
	$datahead = substr($tabledata,0,1) ;
	# $datahead = 行の最初の一文字
	# $tabledata = 行のデータすべて(改行なし) ;
	
	
	if ($datahead =~ /[a-z]/){
		# 連想配列を使って列車種別を配列に入れる。($wkstr3は無いはず)
		# %mark_train
		($wkstr1,$wkstr2,$wkstr3) = split(/:/,$tabledata);
		($wkstr4,$wkstr5) = split(/;/,$wkstr2);
		$mark_train{$wkstr1} = $wkstr4	;

	}elsif($datahead =~ /[A-Z]/){
		# 連想配列を使って行き先を配列に入れる。($wkstr3は無いはず)
		# %mark_station
		($wkstr1,$wkstr2,$wkstr3) = split(/:/,$tabledata);
		($wkstr4,$wkstr5) = split(/;/,$wkstr2);
		$mark_station{$wkstr1} = $wkstr4	;
	
	}elsif($datahead =~ /\[/){
		# [sat][hol][sun]などの曜日別の表のヘッダー 
		# $tabledata = [sat][hol][sun] 
		# $myday : 曜日フラグ
		if ( $inPROCESS > 0 ) {
			# 土曜処理とか日曜処理が終わった後に、ループ終了させる
			# print  "LAST !!! \n" ;
			last ; # 
		};
		
		
		if ($tabledata =~ /SAT/i) {
			if ($myday == 6) {
				# 土曜日処理
				# 貯めたデータは平日のものなので全部廃棄
				# 新たに集め直す
				# print  "Saturday !!! \n" ;
				$max = @returnstr;
				for($i=0;$i < $max; $i++){	pop(@returnstr) ; }	;
				$inPROCESS = 1 ;
			}
		}
				
		if ($tabledata =~ /SUN/i) {
			if ($myday == 0 ){
				# 日曜処理
				# 貯めたデータは平日のものなので全部廃棄
				# print  "Sunday !!! \n" ;
				$max = @returnstr;
				for($i=0;$i < $max; $i++){	pop(@returnstr);	}	;
				$inPROCESS = 1 ;
			}
		}
				
		if( $tabledata =~ /HOL/i) {
			if($myday == 7) {
				# 祝日処理
				# 貯めたデータは平日のものなので全部廃棄
				# print  "Holiday !!! \n" ;
				$max = @returnstr;
				for($i=0;$i < $max; $i++){	pop(@returnstr);	}	;
				$inPROCESS = 1 ;
			}
		}
				
		if ( ( 0 < $myday ) && ( $myday < 6 ) ) {
			# 月〜金
			# print  "LAST !!! \n" ;
			last ; # 今はこれが来たら終了 
		};

		next;
		
	}elsif($datahead =~ /$SHARP/){	# $SHARP = #
		# #で始まるタイトル行
		# ほげほげ処理
		# 後で機能追加するかも しないかも
		next;
		
#		}elsif($datahead =~ /$DOLLER/){	# $DOLLER = $
#			# $で始まるタイトル行
#			# ほげほげ処理
#			# 後で機能追加するかも しないかも
#			next;
		
	}elsif($datahead =~ /[0-9]/){
		# 数字で始まる行は時刻表データ
		#  5: Zg6 Zg21 Zf27 Zg34 Zf41 Ze47 Zg54
		($wkstr1,$wkstr2,$wkstr3) = split(/:/,$tabledata);
		# 2:59までは前日とする。
		if ($wkstr1 < 3){ $wkstr1 += 24 ;};
		
		# $wkstr1 読み込んだデータの時刻 
		if ($wkstr1 < $myhour){
			next; 
		}else{
			# ($wkstr1 => $myhour)のとき
			#
			# 3つ貯め込む
			# 貯まったら後は不要なので終了
			#
			# 行頭のスペースを削除(タブも)
			$wkstr2 =~ s/^\s+//g ;	
			$wkstr2 =~ s/\t/\ /g ;	
			$wkstr2 =~ s/\s+/\ /g ;	
			@wkarrayMM = split(/\ /,$wkstr2) ;
			# (Zg6 ,Zg21 ,Zf27 ,Zg34 ,Zf41 ,Ze47 ,Zg54)こんな感じ
			foreach $wkMM(@wkarrayMM){
				$wkmm = $wkMM ;
				$wktrain = $wkMM ;
				$wkto = $wkMM ;
				# 数字以外を削除
				$wkmm =~ s/\D//g ; 	
				# 小文字以外を削除
				$wktrain =~ s/[^a-z]//g ;
				# 大文字以外を削除 
				$wkto =~ s/[^A-Z]//g ;
				# 検索(比較)用の時刻を作る
				$wkhhmm = $wkstr1 * 60 + $wkmm; 
				if ($wkhhmm <= $myhhmm){ 
					next ;
				}else{
			# Debug Mode 
#			if ( $DEBUG > 0 ){
#				print "A \$wkhhmm = $wkhhmm : " ;
#				print "\$myhhmm = $myhhmm : " ;
#				print "\$wkstr1 = $wkstr1 : \n" ;
#				print "A \$wkstr2 = $wkstr2 : \n" ;
#			};
					# すでに12個データが貯まっている時は読み飛ばし
					# 休日ダイヤの処理があるので終わらせずに続きを読む
					if(@returnstr >= 12 ){
						next ;
					}
					# 「列車種別,時,分,行き先」を貯める
					# 列車種別 = $mark_train{$wktrain}
					# 時 = $wkstr1
					# 分 = $wkmm
					# 行き先 = $mark_station{$wkto}
					# 
					# 列車種別 = $mark_train{$wktrain}
					if(exists($mark_train{$wktrain})){
						push(@returnstr,$mark_train{$wktrain});
					}else{
						push(@returnstr,$UNKNOWN);
					};
					# 
					# 時 = $wkstr1
					# $arraywkstr1 = $wkstr1 ;
					$arraywkstr1 = $wkstr1 ;
					if( $arraywkstr1 >= 24 ){	$arraywkstr1 -= 24 ; } ;
					push(@returnstr,$arraywkstr1);
					# 分 = $wkmm
					push(@returnstr,sprintf("%02d",$wkmm));	# 分を01,02,03,,,に
					# 行き先 = $mark_station{$wkto}
					if(exists($mark_station{$wkto})){
						push(@returnstr,$mark_station{$wkto});
					}else{
						push(@returnstr,$NOWHERE);
					};
					# @returnstr に配列が4*3=12個貯まったら終わり
				};
			};
		};
	};
};
# 時刻表の最後まで読んだ。
# 終わりの方だと3件貯まらずにここに来る 
# とりあえず最後に12個スペース詰める
@returnstr = (@returnstr," "," "," "," "," "," "," "," "," "," "," "," ") ;
# $#hoge は配列の最後のインデックス数 (@hoge は配列の数。$#hoge + 1 = @hoge)
# で、$#hoge に数字を入れると配列の数がその数になる (知らなかったよ)
$#returnstr = 12 - 1 ; 
print (join(",",@returnstr));

# debug 
# デバッグモード
if ( $DEBUG > 0 ){
	open(ERR,">>ERROR.txt");
	print ERR `date` ;
	close(ERR);
};
exit();

__END__ 
